<!DOCTYPE html>
<html lang="en">

<head>
   <meta charset="UTF-8">
   <meta name="viewport" content="width=device-width, initial-scale=1.0">
   <!-- Basic SEO -->
   <title>Bangla Converter | AdarshaLipi ⇆ Bijoy, Converter</title>
   <meta name="description" content="Bangla Converter - Unicode ⇆ Bijoy, Unicode ⇆ Boishakhi Converter, AdarshaLipi & vice versa. Fast, accurate & free online Bangla converter tool for everyone.">
   <meta name="keywords" content="Bangla Converter, Unicode to Bijoy, Bijoy to Unicode, Avro Converter, SutonnyMJ Converter, AdarshaLipi Converter, Bengali Font Converter, Bangla typing tool">
   <meta name="author" content="Your Name or Company">

   <!-- Open Graph (Facebook, LinkedIn, etc.) -->
   <meta property="og:title" content="Bangla Converter - Unicode ⇆ Bijoy, Unicode ⇆ Boishakhi Converter, AdarshaLipi Converter">
   <meta property="og:description" content="Free Bangla Converter tool to convert Unicode, Bijoy, Avro, SutonnyMJ, AdarshaLipii easily online. Perfect for typing, publishing & document preparation.">
   <meta property="og:type" content="website">
   <meta property="og:url" content="https://kajjdao.com/">
   <meta property="og:image" content="https://kajjdao.com/thumbnail.png">

   <!-- Twitter Card -->
   <meta name="twitter:card" content="summary_large_image">
   <meta name="twitter:title" content="Bangla Converter | Unicode ⇆ Bijoy, Avro, Sutonny, AdarshaLipi Converter">
   <meta name="twitter:description" content="Free Bangla Converter tool to convert Unicode, Bijoy, Avro, SutonnyMJ, AdarshaLipi easily online.">
   <meta name="twitter:image" content="https://kajjdao.com/thumbnail.png">

   <!-- Extra SEO/Usability -->
   <link rel="canonical" href="https://adarshalipiconverter.kajjdao.com/">
   <meta name="robots" content="index, follow">
   <meta name="theme-color" content="#009688">
   <meta name="language" content="bn,en">
   <meta name="revisit-after" content="7 days">
   <script src="test.js"></script>
   <meta name="google-adsense-account" content="ca-pub-9911814387967244">

   <link rel="stylesheet" href="index.css">
   <script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-9911814387967244" crossorigin="anonymous"></script>
   
   <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.8/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-sRIl4kxILFvY47J16cr9ZwB07vP4J8+LH7qKQnuqkuIAvNWLzeN8tE5YBujZqJLB" crossorigin="anonymous">

</head>

<body>
   <div id="fb-root"></div>
   <script async defer crossorigin="anonymous" src="https://connect.facebook.net/en_GB/sdk.js#xfbml=1&version=v23.0&appId=APP_ID"></script>

   <div class="container-fluid ">
      <div class="row">
         <div class="col-md-3 bg-light">
   <!-- Navbar (for mobile menu button) -->
   <nav class="navbar navbar-light bg-light d-md-none">
      <div class="container-fluid">
         <button class="btn btn-outline-primary" type="button" data-bs-toggle="offcanvas" data-bs-target="#sidebarMenu">
            ☰ Menu
         </button>
      </div>
   </nav>

   <!-- Sidebar -->
   <div class="offcanvas offcanvas-start d-md-block bg-light" tabindex="-1" id="sidebarMenu">
      <div class="offcanvas-header d-md-none">
         <h5 class="offcanvas-title">Menu</h5>
         <button type="button" class="btn-close text-reset" data-bs-dismiss="offcanvas"></button>
      </div>
      <h3 class="h4">Kajjdao Font Converters:</h3>
      <p class="text-sm">Sponsered by <a href="https://kajjdao.com">Kajjdao</a></p>
      <div class="offcanvas-body p-1 rounded" style="background:#666685ff">
         <ul class="nav flex-column">
            
            <li class="nav-item">
               <a href="index.php"
                  class="nav-link rounded px-2 py-1 mb-1 border border-1 text-light ">ইউনিকোড
                  ⇆ আদর্শলিপি টেক্সট কনভার্টার</a>
            </li>
            <li class="nav-item">
               <a href="docx.php"
                  class="nav-link rounded px-2 py-1 mb-1 border border-1 text-light ">ইউনিকোড
                  ⇆ আদর্শলিপি ফাইল কনভার্টার</a>
            </li>
            <li class="nav-item">
               <a href="banglaconverter.php"
                  class="nav-link rounded px-2 py-1 mb-1 border border-1 text-light ">ইউনিকোড
                  ⇆ বিজয় টেক্সট কনভার্টার</a>
            </li>
            <li class="nav-item">
               <a href="bijoyadarshalipiconverter.php"
                  class="nav-link rounded px-2 py-1 mb-1 border border-1 text-light active">আদর্শলিপি
                  ⇆ বিজয় টেক্সট কনভার্টার</a>
            </li>
            <li class="nav-item">
               <a href="#" class="nav-link rounded px-2 py-1 mb-1 border border-1 text-light">সহায়তা</a>
            </li>
         </ul>
      </div>
   </div>
   <style>
   /* Active page style */
   .nav-item .active {
      background: #4e4e9c;
      cursor: default;
      pointer-events: none;
      /* disable link */
   }

   .nav-link:hover {
      background-color: #3a3a4b;
   }

   @media (min-width: 768px) {
      #sidebarMenu {
         display: block !important;
         position: relative;
         transform: none;
         visibility: visible;
      }

      .nav-link {
         padding: 0;
      }

      .offcanvas-start {
         border: none !important;
      }
   }

   #uni {
      font-size: large;
   }
</style>
</div>         <div class="col-md-6">
            <div class="main">
               <h1>AdarshaLipi ⇆ Bijoy Converter</h1>

               <div style="background: rgb(201, 227, 238); padding: .25rem;">
                  <h2 style="color:red; text-align: left; text-decoration: underline;">AdarshaLipi:</h2>
                  <p style="margin-bottom: 0;">
                     <textarea class="AdarshaLipiNormal" id="adar" rows="8" cols="52" autofocus placeholder="BcnÑ¢m¢f HM¡®e V¡Cf Ll¤e..."></textarea>
                  </p>
                  <div><button class="copy-text" id="copy-text-2" onclick="copyTextU()">Copy text</button><span id="msg-2">text copied</span></div>
               </div>
               <div style="width: 100%; text-align: center;">
                  <button class="convertButton" onclick="conv('a2b')">Convert ▼</button>
                  <button class="convertButton" onclick="conv('b2a')">Convert ▲</button>
               </div>
               <!---->
               <div style="background: rgb(201, 227, 238); padding: .25rem;">
                  <h2 style="color:red; text-align: left; text-decoration: underline;">Bijoy (sutonnyMJ):</h2>
                  <p style="margin-bottom: 0;"><textarea class="bijoy" id="bijoy" rows="7" cols="60" placeholder="weRq GLv‡b UvBc Kiæb..."></textarea></p>
                  <div><button class="copy-text" id="copy-text-1" onclick="copyTextA()">Copy text</button><span id="msg-1">text copied</span></div>
               </div>
               <br><br>
               <p style="color:red"><b>বিঃ দ্রঃ</b> বৈশাখী ফন্ট কনভার্টার প্রয়োজন হলে জানাবেন। প্রয়োজনীয়তার ভিত্তিতে এটি এই সাইটে সংযুক্ত করা হবে।</p>
               <div class="fb-comments" data-href="http://adarshalipiconverter.kajjdao.com/banglaconverter.php" data-width="100%" data-numposts="5"></div>
            </div>
         </div>
         <div class="col-md-3 bg-light">
            <div class="adpanel">
    <div class=" p-2 rounded border border-danger" id="adpanel">
        <p style="font-size:16px;color:#006400;"><b></b>Hand Made Hair Revitalization Oil</b></p>
        <img class="img rounded" src="data:image/jpeg;base64,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" />
        <p style="font-size:small">প্রাকৃতিক উপাদানে তৈরি এই হ্যান্ড মেইড হেয়ার রিভিটালাইজেশন অয়েল চুলের যত্নে এক নতুন মাত্রা যোগ করে। বিস্তারিত...</p>
        <!--<p style="font-size:small"><b>ব্যবহারের নিয়ম:</b> চুলে প্রতিদিন হালকা ম্যাসাজ করুন। রাতে ব্যবহার করলে চুল আরও পুষ্টি পায় এবং সকালে ধুয়ে নিলে চুল নরম, ঘন ও সুস্থ দেখাবে।</p>-->
    </div>
</div>
<style>
    @media screen and (min-width: 768px){
        .adpanel{
            min-height:75vh;
            padding:4px;
        }
    }
    .adpanel img{
        max-width:100%;
    }
    .adpanel{
        text-align:center;
        cursor: pointer;
    }
    .developer{
        text-align:center;
        margin:2px;
    }

    h1{
        font-size:1.3rem;
    }
    h2{
        font-size:1.1rem;
    }
</style>
<div class="developer">
    <h1 style="color:purple;font-size:18px">Kajjdao Bangla Font Converter</h1>
    <p>Developed by</p>
    <address>
        Md. Zahirul Islam<br>
        Workshop Instructor<br>
        Sylhet Cadet College<br>
    </address>
</div>

<script>
    document.getElementById("adpanel").addEventListener("click", function() {
        window.location.href = 'https://m.me/kajjdao?ref=BCad';
    });

</script>         </div>
      </div>
   </div>

   <script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-9911814387967244" crossorigin="anonymous"></script>

   <script src="adorshotouni.js"></script>
   <script src="unitoadorsho.js"></script>

   <!--adsense Kajjdao 1 -->
   <ins class="adsbygoogle"
      style="display:block"
      data-ad-client="ca-pub-9911814387967244"
      data-ad-slot="7441538915"
      data-ad-format="auto"
      data-full-width-responsive="true"></ins>
   <script>
      (adsbygoogle = window.adsbygoogle || []).push({});
   </script>
   <script>
      function conv(dir) {
         let b = document.getElementById("bijoy");
         let a = document.getElementById("adar");
         dir === "a2b" ?
            b.value = BanglaConverter.ConvertToASCII("bijoy", convertToAdarshalipi(a.value)) //convert to bijoy
            :
            a.value = convertToUnicode(BanglaConverter.ConvertToUnicode("bijoy", b.value)); //convert to uni
      }
   </script>
   <script>
    function copyTextA(){
   let copyText = document.getElementById("bijoy");
   copyText.select();
   navigator.clipboard.writeText(copyTo);
   document.getElementById("msg-1").style.opacity=1;
   document.getElementById("msg-1").style.visibility='visible';
   setTimeout(disappearMsg1, 2000);
}
function copyTextU(){
   let copyText = document.getElementById("adar");
   copyText.select();
   navigator.clipboard.writeText(copyText.value);
   document.getElementById("msg-2").style.opacity=1;
   document.getElementById("msg-2").style.visibility='visible';
   setTimeout(disappearMsg2, 2000);
}
function disappearMsg1(){
   document.getElementById("msg-1").style.visibility='hidden';
   document.getElementById("msg-1").style.opacity=0;
}
function disappearMsg2(){
   document.getElementById("msg-2").style.visibility='hidden';
   document.getElementById("msg-2").style.opacity=0;
}
</script>
   <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.8/dist/js/bootstrap.min.js" integrity="sha384-G/EV+4j2dNv+tEPo3++6LCgdCROaejBqfUeNjuKAiuXbjrxilcCdDz6ZAVfHWe1Y" crossorigin="anonymous"></script>

<style>
.container{
min-height:96vh;
}

</style>
<footer style="
  
  width: 100%;
  background: #222;
  color: white;
  text-align: center;
  padding: 10px 0;
">
  © 2025 <a href='https://kajjdao.com' style='color:green'>Kajjdao</a>
</footer>
</body>

</html>